/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.biomes;

import dangerzone.biomes.Biome;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Blocks;
import dangerzone.rendering.Fastmath;
import dangerzone.world.Chunk;
import dangerzone.world.Ores;
import dangerzone.world.World;

public class BigTreeBiome
extends Biome {
    Trees tr = new Trees();

    public BigTreeBiome(String s) {
        super(s);
    }

    @Override
    public void generateheightmaps(World w, int d, Chunk c, int cx, int cz, int[][] dirtheight, int[][] stoneheight, int[][] baseheight) {
        int k;
        float[][] noise = new float[16][16];
        float[][] noise2 = new float[16][16];
        int dirtamp = 2;
        int dx = (cx << 4) + (int)(w.worldseed & 0xFFFFL);
        int dz = (cz << 4) + (int)(w.worldseed >> 16 & 0xFFFFL);
        dx %= 1080000;
        dz %= 1080000;
        int i = 0;
        while (i < 16) {
            k = 0;
            while (k < 16) {
                noise[i][k] = 1.0f;
                noise2[i][k] = (float)Fastmath.sin((double)(dx + i) / 188.0 % Math.PI) * 2.0f;
                float[] fArray = noise2[i];
                int n = k;
                fArray[n] = fArray[n] * ((float)Fastmath.sin((double)(dz + k) / 137.0 % Math.PI) * 2.0f);
                float[] fArray2 = noise2[i];
                int n2 = k;
                fArray2[n2] = fArray2[n2] * ((float)Fastmath.sin((double)(dx + i) / 100.0 % Math.PI) * 2.0f);
                float[] fArray3 = noise2[i];
                int n3 = k;
                fArray3[n3] = fArray3[n3] * ((float)Fastmath.sin((double)(dz + k) / 61.0 % Math.PI) * 2.0f);
                ++k;
            }
            ++i;
        }
        int j = 1;
        while (j < 4) {
            i = 0;
            while (i < 16) {
                k = 0;
                while (k < 16) {
                    float[] fArray = noise[i];
                    int n = k;
                    fArray[n] = fArray[n] + (float)Fastmath.sin(Math.toRadians((double)(dx + i) / (11.0 / (double)j)));
                    float[] fArray4 = noise[i];
                    int n4 = k;
                    fArray4[n4] = fArray4[n4] + (float)Fastmath.sin(Math.toRadians((double)(dz + k) / (9.0 / (double)j)));
                    float[] fArray5 = noise[i];
                    int n5 = k;
                    fArray5[n5] = fArray5[n5] * (float)Fastmath.sin(Math.toRadians((double)(dx + i) / (7.0 / (double)j)));
                    float[] fArray6 = noise[i];
                    int n6 = k;
                    fArray6[n6] = fArray6[n6] * (float)Fastmath.sin(Math.toRadians((double)(dz + k) / (5.0 / (double)j)));
                    float[] fArray7 = noise[i];
                    int n7 = k;
                    fArray7[n7] = fArray7[n7] * (float)Fastmath.sin(Math.toRadians((double)(dx + i) / (5.0 / (double)j)));
                    float[] fArray8 = noise[i];
                    int n8 = k;
                    fArray8[n8] = fArray8[n8] * (float)Fastmath.sin(Math.toRadians((double)(dz + k) / (3.0 / (double)j)));
                    float[] fArray9 = noise[i];
                    int n9 = k;
                    fArray9[n9] = fArray9[n9] * (float)Fastmath.sin(Math.toRadians((double)(dx + i) * (2.0 / (double)j)));
                    float[] fArray10 = noise[i];
                    int n10 = k;
                    fArray10[n10] = fArray10[n10] * (float)Fastmath.sin(Math.toRadians((dz + k) * (3 / j)));
                    float[] fArray11 = noise[i];
                    int n11 = k;
                    fArray11[n11] = fArray11[n11] * (float)Fastmath.sin(Math.toRadians((dx + i) * (3 / j)));
                    float[] fArray12 = noise[i];
                    int n12 = k;
                    fArray12[n12] = fArray12[n12] * (float)Fastmath.sin(Math.toRadians((dz + k) * (5 / j)));
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        i = 0;
        while (i < 16) {
            k = 0;
            while (k < 16) {
                float[] fArray = noise[i];
                int n = k++;
                fArray[n] = fArray[n] * 35.0f;
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            k = 0;
            while (k < 16) {
                double t = noise[i][k] * 2.1f + (float)this.avgheight;
                stoneheight[i][k] = (int)t;
                t = Math.abs(noise2[i][k] / 2.0f * (float)dirtamp);
                dirtheight[i][k] = (int)t;
                int[] nArray = dirtheight[i];
                int n = k;
                nArray[n] = nArray[n] + stoneheight[i][k];
                if (stoneheight[i][k] < this.waterlevel + 10 && stoneheight[i][k] >= this.waterlevel) {
                    t = Math.abs(noise2[i][k] / 2.0f * (float)dirtamp) * ((float)stoneheight[i][k] - (float)this.waterlevel) / 10.0f;
                    dirtheight[i][k] = (int)t;
                    int[] nArray2 = dirtheight[i];
                    int n13 = k;
                    nArray2[n13] = nArray2[n13] + stoneheight[i][k];
                }
                baseheight[i][k] = 0;
                ++k;
            }
            ++i;
        }
    }

    @Override
    public void generate(World w, int d, Chunk c, int cx, int cz, int[][] lm1, int[][] lm2, int[][] lm3) {
        int waterlevel = 60;
        int j = 0;
        while (j < 200) {
            int i = 0;
            while (i < 16) {
                int k = 0;
                while (k < 16) {
                    if (j < lm2[i][k]) {
                        c.setblock(i, j, k, Blocks.stone.blockID);
                    } else if (j <= waterlevel) {
                        c.setblock(i, j, k, Blocks.waterstatic.blockID);
                        if (j == waterlevel && c.getblock(i, j - 1, k) == Blocks.stone.blockID) {
                            c.setblock(i, j - 1, k, Blocks.sand.blockID);
                        }
                    } else {
                        if (j < lm1[i][k] && j < 120 && c.getblock(i, j - 1, k) != Blocks.waterstatic.blockID && c.getblock(i, j - 1, k) != 0) {
                            c.setblock(i, j, k, Blocks.dirt.blockID);
                        }
                        if (j == lm1[i][k] && j < 100 && c.getblock(i, j - 1, k) == Blocks.dirt.blockID) {
                            c.setblock(i, j, k, Blocks.grassblock.blockID);
                            c.setblockmeta(i, j, k, w.rand.nextInt(4) << 12);
                        }
                    }
                    if (j == 0) {
                        c.setblock(i, j, k, Blocks.stopblock.blockID);
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        Ores.generate(w, d, this, c, cx, cz);
    }

    @Override
    public void decorate(World world, int d, Chunk c, int chunkx, int chunkz) {
        this.tr.addGrass(world, d, chunkx << 4, chunkz << 4, c);
    }
}

